//
// (c) 2023 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import "private"

UiTextEditBase {
    id : uiTextEdit

    horizontalMargin : 6
    verticalMargin   : 4

    children : UiBorder {
        id : border

        anchors.fill : parent
        borderWidth : 1
        color : {
            if (!uiTextEdit.enabled) {
                return UiColors.getColor(UiColors.DisabledLightGrey13);
            } else if (uiTextEdit.readOnly) {
                return UiColors.getColor(UiColors.ControlGrey20);
            } else if (uiTextEdit.activeFocus) {
                return UiColors.getColor(UiColors.SelectionGreen);
            } else if (uiTextEdit.hover) {
                return UiColors.getColor(UiColors.HoverGreen);
            }

            return UiColors.getColor(UiColors.ControlGrey20);
        }
        style : UiBorder.Solid
        z : 100
    }
}
